package pt.caf_pbs.schooldiskapi.controller;

import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.server.ResponseStatusException;
import pt.caf_pbs.schooldiskapi.dao.FilesOperation;
import pt.caf_pbs.schooldiskapi.dto.SubjectDTO;
import pt.caf_pbs.schooldiskapi.dto.SubjectUpdateDTO;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;
import pt.caf_pbs.schooldiskapi.model.School;
import pt.caf_pbs.schooldiskapi.model.Subject;

import java.util.List;

@RestController
@RequestMapping("/v1/subject")
public class SubjectsController {
    @PutMapping("{initials}")
    public Subject updateSubject(@PathVariable String initials, @RequestBody SubjectUpdateDTO subjectDTO) {
        try {
            School school = FilesOperation.loadSchool();
            school.getSubjectContainer().update(initials, subjectDTO.getDesignation());
            FilesOperation.storeSchool(school);
            return school.getSubjectContainer().get(initials);
        }catch(InvalidDataException e ){
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with "+e.getMessage(), e);
        }
    }

    @PostMapping
    public Subject createSubject(@RequestBody SubjectDTO subjectDTO) {
        try {
            School school = FilesOperation.loadSchool();
            Subject newSubject = new Subject(subjectDTO);
            school.getSubjectContainer().add(newSubject);
            FilesOperation.storeSchool(school);
            return newSubject;
        }catch(DuplicatedDataException | InvalidDataException e ){
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with "+e.getMessage(), e);
        }
    }

    @GetMapping("{initials}")
    public Subject getSubject(@PathVariable String initials) {
        School school = FilesOperation.loadSchool();
        Subject subject = school.getSubjectContainer().get(initials);
        if(subject != null){
            return subject;
        }else{
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Subject with id " + initials + " found");
        }
    }

    @GetMapping("all")
    public List<Subject> getAllSubject() {
        School school = FilesOperation.loadSchool();
        List<Subject> subject = school.getSubjectContainer().getSubjects();
        if(CollectionUtils.isEmpty(subject)){
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Subjects found");
        }
        return subject;
    }

    @DeleteMapping("{initials}")
    public Subject deleteSubject(@PathVariable String initials) {
        School school = FilesOperation.loadSchool();
        Subject student = school.getSubjectContainer().get(initials);
        if(student != null){
            school.getSubjectContainer().remove(initials);
            FilesOperation.storeSchool(school);
            return student;
        }else{
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Subject with initials " + initials + " found");
        }
    }
}
